/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;
import oracle.ewt.UIManager;
import oracle.ewt.dataSource.ArrayOneDDataSource;
import oracle.ewt.dataSource.ArrayTwoDDataSource;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.graphics.Appearance;
import oracle.ewt.grid.AppearanceManager;
import oracle.ewt.grid.ComplexAppearanceManager;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridEvent;
import oracle.ewt.grid.GridSelection;
import oracle.ewt.grid.SingleRowSelection;
import oracle.ewt.grid.StandardNavigator;
import oracle.ewt.header.Header;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.table.SpreadTable;
import oracle.ewt.table.TableEvent;
import oracle.ewt.table.TableResizeListener;
import oracle.ewt.table.TableRowSelectListener;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.ewt.util.StringUtils;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiClusterConfig
extends OiifpWizPanel
implements ItemListener,
ActionListener,
ComponentListener,
TableRowSelectListener,
TableResizeListener {
    private static final String DEFAULT_TITLE = "Specify Cluster Configuration";
    private static final String DEFAULT_PROMPT = "Indicate the cluster name and the set of nodes that you wish to make part of the cluster.  For each node, specify a public node name (host name), private node name used for private inter-node communication, and a virtual host name that is used for fast failover from clients.\n\nFor clusters with a large number of nodes, you may alternatively use a cluster configuration file to completely specify the cluster configuration.";
    private static final String DEFAULT_LABEL = "&Cluster Name: ";
    private static final String DEFAULT_SUBTITLE = "Cluster Nodes";
    private static final String[] DEF_LIST = new String[]{"host1:host1-priv:host1-vip:Y:N", "host2:host2-priv:host2-vip:N:Y"};
    private static final String[] DEF_SEL_LIST = new String[0];
    private static final String[] DEF_COL_HEADERS_NON_VENDOR = new String[]{OiStdDialogRes.getString("OiClusterConfig_PubNodeName"), OiStdDialogRes.getString("OiClusterConfig_PrivNodeName"), OiStdDialogRes.getString("OiClusterConfig_VirtualHostName")};
    private static final String[] DEF_COL_HEADERS_VENDOR = new String[]{OiStdDialogRes.getString("OiClusterConfig_PubNodeName"), OiStdDialogRes.getString("OiClusterConfig_PrivNodeName"), OiStdDialogRes.getString("OiClusterConfig_VirtualHostName"), OiStdDialogRes.getString("OiClusterConfig_9iRACPresent")};
    private boolean isVendorCluster = false;
    private boolean win92Cluster = false;
    private String passedClusterConfigFile = null;
    private static final String ERROR_TITLE = OiStdDialogRes.getString("OiClusterConfigFileInput_ALERT_ERROR_TITLE");
    private static final String ERROR_MESSAGE = OiStdDialogRes.getString("OiClusterConfig_PROCEED_WITHOUT_FILE");
    private static final String PRIVATE_NAME_EXTENSION = "_priv";
    private static final String DEF_BUTTON_LABEL_0 = "Use Cluster Configuration File ...";
    private static final String DEF_BUTTON_LABEL_1 = "Add ...";
    private static final String DEF_BUTTON_LABEL_2 = "Edit ...";
    private static final String DEF_BUTTON_LABEL_3 = "Remove";
    private static final int PUBLIC_NAME_COL_WIDTH = 200;
    private static int COLWIDTH = 590;
    private static int NO_ROWS;
    private static int totRows;
    private MultiLineLabel myPrompt = new MultiLineLabel(WordWrapper.getTextWrapper(), "Indicate the cluster name and the set of nodes that you wish to make part of the cluster.  For each node, specify a public node name (host name), private node name used for private inter-node communication, and a virtual host name that is used for fast failover from clients.\n\nFor clusters with a large number of nodes, you may alternatively use a cluster configuration file to completely specify the cluster configuration.");
    private LWLabel myLabel = new LWLabel("&Cluster Name: ");
    private LWTextField myTextField = new LWTextField();
    private LWLabel mySubtitle = new LWLabel("Cluster Nodes");
    private LWContainer subPanel = null;
    private ArrayTwoDDataSource myData;
    private ArrayOneDDataSource myHeader;
    private SpreadTable myTable;
    private Grid grid;
    private Font spreadTableFont;
    private ScrollBox tableScroll;
    private Appearance appearanceObj;
    private ComplexAppearanceManager complexAppMngrObj = null;
    private LWButton button0 = new LWButton("Use Cluster Configuration File ...");
    private LWButton button1 = new LWButton("Add ...");
    private LWButton button2 = new LWButton("Edit ...");
    private LWButton button3 = new LWButton("Remove");
    private GridBagLayout gridbag;
    private GridBagConstraints c;
    private SingleRowSelection gridSel;
    private boolean isPubNodeEditable = true;
    private boolean isPrivNodeEditable = true;
    private String[] spreadTableArray = null;
    private String[] spreadTablePopulatedByAPI = null;
    private Vector removedNodesPopulatedByAPI = new Vector();
    private int numberOfCols = 0;
    private int rowHighlighted = 0;

    public OiClusterConfig() {
        super(DEFAULT_TITLE);
        this.paintDialog();
    }

    public void paintDialog() {
        this.gridbag = new GridBagLayout();
        this.mainPanel.setLayout((LayoutManager)this.gridbag);
        this.c = new GridBagConstraints();
        this.c.fill = 1;
        this.setTitleLabel(DEFAULT_TITLE);
        this.setPrompt(DEFAULT_PROMPT);
        this.setLabel(DEFAULT_LABEL);
        this.myTextField.setMaximumChars(15);
        this.createSubPanel();
        this.setSubTitle(DEFAULT_SUBTITLE);
        this.addComponent((Component)this.myPrompt, (Container)this.mainPanel, this.gridbag, this.c, 1, 17, 0, 0, 4, 1, 1.0, 1.6, new Insets(0, 0, 0, 0));
        this.addComponent((Component)this.myLabel, (Container)this.mainPanel, this.gridbag, this.c, 1, 17, 0, 1, 1, 1, 0.0, 0.0, new Insets(0, 0, 0, 0));
        this.addComponent((Component)this.myTextField, (Container)this.mainPanel, this.gridbag, this.c, 1, 17, 1, 1, 3, 1, 0.0, 0.0, new Insets(0, 0, 0, 380));
        this.addComponent((Component)this.subPanel, (Container)this.mainPanel, this.gridbag, this.c, 1, 17, 0, 3, 4, 1, 0.0, 1.0, new Insets(10, 0, 0, 0));
        this.myTable.addComponentListener((ComponentListener)this);
        this.myTable.addRowSelectListener((TableRowSelectListener)this);
        this.myTable.addResizeListener((TableResizeListener)this);
        this.button0.addActionListener((ActionListener)this);
        this.button1.addActionListener((ActionListener)this);
        this.button1.setEnabled(false);
        this.button2.addActionListener((ActionListener)this);
        this.button3.addActionListener((ActionListener)this);
    }

    private void createSubPanel() {
        GridBagLayout gridBag1 = new GridBagLayout();
        GridBagConstraints c1 = new GridBagConstraints();
        this.subPanel = new LWContainer();
        this.subPanel.setLayout((LayoutManager)gridBag1);
        this.numberOfCols = DEF_COL_HEADERS_VENDOR.length;
        this.myHeader = new ArrayOneDDataSource((Object[])DEF_COL_HEADERS_VENDOR);
        this.myData = new ArrayTwoDDataSource(this.numberOfCols, NO_ROWS);
        this.myTable = new SpreadTable((TwoDDataSource)this.myData, (OneDDataSource)this.myHeader, null);
        this.complexAppMngrObj = new ComplexAppearanceManager();
        this.myTable.getGrid().setAppearanceManager((AppearanceManager)this.complexAppMngrObj);
        this.complexAppMngrObj.getColumnAppearance(3).setVerticalJustify(1);
        int colWidth = COLWIDTH / this.numberOfCols;
        for (int i = 0; i < this.numberOfCols; ++i) {
            this.myTable.setColumnWidth(i, colWidth);
        }
        this.myTable.setHorizontalSeparatorsVisible(false);
        this.myTable.setVerticalSeparatorsVisible(false);
        this.grid = this.myTable.getGrid();
        this.gridSel = new SingleRowSelection();
        this.grid.setGridSelection((GridSelection)this.gridSel);
        this.grid.setGridKeyNavigator(StandardNavigator.getTabKeyNavigator());
        this.tableScroll = new ScrollBox((Component)this.myTable, 0, 0);
        this.addComponent((Component)this.tableScroll, (Container)this.subPanel, gridBag1, c1, 1, 17, 0, 0, 0, 1, 1.0, 1.5, new Insets(0, 0, 0, 0));
        this.addComponent((Component)this.button0, (Container)this.subPanel, gridBag1, c1, 0, 17, 0, 2, 1, 1, 1.0, 0.0, new Insets(0, 0, 5, 0));
        this.addComponent((Component)this.button1, (Container)this.subPanel, gridBag1, c1, 0, 13, 2, 2, 1, 1, 1.0, 0.0, new Insets(0, 150, 0, 0));
        this.addComponent((Component)this.button2, (Container)this.subPanel, gridBag1, c1, 0, 13, 3, 2, 1, 1, 1.0, 0.0, new Insets(0, 0, 0, 0));
        this.addComponent((Component)this.button3, (Container)this.subPanel, gridBag1, c1, 0, 13, 4, 2, 1, 1, 1.0, 0.0, new Insets(0, 0, 0, 0));
    }

    private void addComponent(Component src, Container dest, GridBagLayout gbl, GridBagConstraints gbc, int fill, int anchor, int x, int y, int w, int h, double weightx, double weighty, Insets insets) {
        gbc.fill = fill;
        gbc.anchor = anchor;
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.insets = insets;
        gbl.setConstraints(src, gbc);
        dest.add(src);
    }

    public void setPrompt(String text) {
        if (text != null) {
            this.myPrompt.setText(text);
        }
    }

    public void setLabel(String text) {
        String label;
        int index;
        if (text != null) {
            this.myLabel.setText(text);
        }
        if ((index = StringUtils.getMnemonicIndex((String)(label = this.myLabel.getText()))) != -1) {
            this.myLabel.setMnemonicIndex(index);
            this.myLabel.setText(StringUtils.stripMnemonic((String)label));
        }
    }

    public void setSubTitle(String text) {
        if (text != null) {
            this.mySubtitle.setText(text);
            this.subPanel.setBorderPainter(UIManager.createGroupBoxPainter((String)this.mySubtitle.getText()));
        }
    }

    public void setButtonLabel0(String text) {
        if (text != null) {
            this.button0.setLabel(text);
        }
    }

    public void setButtonLabel1(String text) {
        if (text != null) {
            this.button1.setLabel(text);
        }
    }

    public void setButtonLabel2(String text) {
        if (text != null) {
            this.button2.setLabel(text);
        }
    }

    public void setButtonLabel3(String text) {
        if (text != null) {
            this.button3.setLabel(text);
        }
    }

    public void setVendorCluster(Boolean vendorClusterFlag) {
        this.isVendorCluster = vendorClusterFlag;
    }

    public void setWin92Cluster(Boolean Win92ClusterFlag) {
        this.win92Cluster = Win92ClusterFlag;
    }

    public void setInitialTable(String[] table) {
        this.invalidate();
        this.spreadTablePopulatedByAPI = table;
        this.validate();
    }

    public void setClusterConfigFile(String clusterConfigFile) {
        this.passedClusterConfigFile = clusterConfigFile == null || clusterConfigFile.trim().length() == 0 ? null : clusterConfigFile;
    }

    public void setTextField(String text) {
        if (text != null) {
            int textLength = this.myTextField.getMaximumChars();
            if (text.length() > textLength && !this.win92Cluster) {
                this.myTextField.setText(text.substring(0, textLength));
            } else if (this.myTextField.isEnabled()) {
                this.myTextField.setText(text);
                if (this.win92Cluster) {
                    this.myTextField.setEnabled(false);
                }
            }
        }
        this.myLabel.setLabelFor((Component)this.myTextField);
    }

    public void setGridTable(String[] answer) {
        if (answer == null || answer[0].trim().equalsIgnoreCase("NULL") || answer[0].trim().equalsIgnoreCase("")) {
            if (!this.isVendorCluster) {
                this.button1.setEnabled(true);
                this.myTable.setColumnVisible(3, false);
                this.numberOfCols = 3;
                int colWidth = COLWIDTH / this.numberOfCols;
                for (int i = 0; i < this.numberOfCols; ++i) {
                    this.myTable.setColumnWidth(i, colWidth);
                }
            }
            if (this.passedClusterConfigFile != null) {
                OiClusterConfigFileInput fileInputDlg = new OiClusterConfigFileInput(this.isVendorCluster, null, this.spreadTablePopulatedByAPI);
                String[][] nodeList = fileInputDlg.populateNodes(this.passedClusterConfigFile);
                boolean areNodesValid = fileInputDlg.evaluateNodes(nodeList);
                if (areNodesValid) {
                    String[] receivedArray = fileInputDlg.getSpreadTableValues();
                    Object finalArray = null;
                    this.setTextField(fileInputDlg.getClusterName());
                    this.setTable(receivedArray, null);
                } else {
                    OiifmAlert.displayAlert((String)ERROR_TITLE, (String)ERROR_MESSAGE, (int)50, (int)1, (int)1, (int)20);
                    this.passedClusterConfigFile = null;
                    this.setTable(this.spreadTablePopulatedByAPI, null);
                }
            } else {
                this.setTable(this.spreadTablePopulatedByAPI, null);
            }
        } else {
            if (!this.isVendorCluster) {
                this.button1.setEnabled(true);
                this.myTable.setColumnVisible(3, false);
                this.numberOfCols = 3;
                int colWidth = COLWIDTH / this.numberOfCols;
                for (int i = 0; i < this.numberOfCols; ++i) {
                    this.myTable.setColumnWidth(i, colWidth);
                }
            }
            this.setTable(answer, null);
            if (this.isVendorCluster) {
                this.refreshRemovedArray();
            }
        }
    }

    public void setTable(String[] answer, String mode) {
        this.grid = this.myTable.getGrid();
        int RowCount = this.myData.getRowCount();
        int Colcount = this.numberOfCols;
        int Idx = 0;
        if (answer.length != 0) {
            if (mode == null || mode.equals("D") || mode.equals("F")) {
                this.spreadTableArray = answer;
                answer = this.modifyInputArray(answer, mode);
                this.myData.removeRows(0, RowCount);
                int divFactor = this.isVendorCluster ? this.numberOfCols + 1 : this.numberOfCols + 2;
                this.myData.addRows(0, answer.length / divFactor);
                for (int rowIdx = 0; rowIdx < answer.length / divFactor; ++rowIdx) {
                    for (int colIdx = 0; colIdx < Colcount; ++colIdx) {
                        Font f;
                        if (Idx % 5 == 0) {
                            if (!this.isVendorCluster) {
                                this.myData.setData(colIdx, rowIdx, (Object)answer[Idx++]);
                                continue;
                            }
                            this.appearanceObj = this.complexAppMngrObj.getCellAppearance(colIdx, rowIdx);
                            f = new Font(OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_DEFAULT_FONT"), 2, 12);
                            this.appearanceObj.setFont(f);
                            this.complexAppMngrObj.setCellAppearance(colIdx, rowIdx, this.appearanceObj);
                            this.myData.setData(colIdx, rowIdx, (Object)answer[Idx++]);
                            continue;
                        }
                        if ((Idx - 1) % 5 == 0) {
                            if (answer[Idx + 3].equalsIgnoreCase("Y")) {
                                this.myData.setData(colIdx, rowIdx, (Object)answer[Idx++]);
                                continue;
                            }
                            this.appearanceObj = this.complexAppMngrObj.getCellAppearance(colIdx, rowIdx);
                            f = new Font(OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_DEFAULT_FONT"), 2, 12);
                            this.appearanceObj.setFont(f);
                            this.complexAppMngrObj.setCellAppearance(colIdx, rowIdx, this.appearanceObj);
                            this.myData.setData(colIdx, rowIdx, (Object)answer[Idx++]);
                            continue;
                        }
                        if ((Idx - 2) % 5 == 0) {
                            this.myData.setData(colIdx, rowIdx, (Object)answer[Idx++]);
                            Idx = this.isVendorCluster ? Idx : Idx + 2;
                            continue;
                        }
                        if ((Idx - 3) % 5 != 0 || !this.isVendorCluster) continue;
                        if (answer[Idx] != null && answer[Idx].equalsIgnoreCase("Y")) {
                            this.myData.setData(colIdx, rowIdx, (Object)OiStdDialogRes.getString("OiClusterConfig_YES"));
                        } else {
                            this.myData.setData(colIdx, rowIdx, (Object)OiStdDialogRes.getString("OiClusterConfig_NO"));
                        }
                        Idx += 2;
                    }
                }
            } else if (mode.equals("A")) {
                answer = this.modifyInputArray(answer, mode);
                this.myData.addRows(RowCount, 1);
                for (int colIdx = 0; colIdx < Colcount; ++colIdx) {
                    this.myData.setData(colIdx, RowCount, (Object)answer[Idx++]);
                }
            } else if (mode.equals("E") || mode.equals("R")) {
                if ((answer = this.modifyInputArray(answer, mode)) == null && mode.equals("R")) {
                    this.myData.removeRows(0, RowCount);
                } else {
                    this.setTable(answer, "D");
                }
            }
        }
        if ((RowCount = this.myData.getRowCount()) != 0) {
            if (this.rowHighlighted == -1) {
                this.rowHighlighted = 0;
            }
            this.gridSel.setRowSelected(this.rowHighlighted, true);
            if (!this.button2.isEnabled()) {
                this.button2.setEnabled(true);
            }
        } else {
            if (this.button2.isEnabled()) {
                this.button2.setEnabled(false);
            }
            if (this.button3.isEnabled()) {
                this.button3.setEnabled(false);
            }
        }
    }

    public Boolean getVendorCluster() {
        return new Boolean(this.isVendorCluster);
    }

    public Boolean getWin92Cluster() {
        return new Boolean(this.win92Cluster);
    }

    public String[] getInitialTable() {
        return this.spreadTablePopulatedByAPI;
    }

    public String getClusterConfigFile() {
        if (this.passedClusterConfigFile == null) {
            return "";
        }
        return this.passedClusterConfigFile;
    }

    public String getTextField() {
        return this.myTextField.getText();
    }

    public String[] getGridTable() {
        String[] gridTableArray = null;
        gridTableArray = this.getTable();
        if (gridTableArray == null) {
            return new String[]{""};
        }
        return gridTableArray;
    }

    public String[] getTable() {
        int Colcount;
        boolean selIdx = false;
        this.grid = this.myTable.getGrid();
        int RowCount = this.myData.getRowCount();
        if (RowCount == 0) {
            return null;
        }
        int n = Colcount = this.isVendorCluster ? this.numberOfCols - 1 : this.numberOfCols;
        if (this.spreadTableArray != null) {
            // empty if block
        }
        String[] selections = new String[RowCount];
        String currentRow = null;
        for (int rowIdx = 0; rowIdx < RowCount; ++rowIdx) {
            currentRow = "";
            for (int colIdx = 0; colIdx < Colcount; ++colIdx) {
                currentRow = currentRow + (String)this.myData.getData(colIdx, rowIdx) + ":";
            }
            selections[rowIdx] = currentRow = currentRow + this.spreadTableArray[rowIdx].split(":")[3] + ":" + this.spreadTableArray[rowIdx].split(":")[4];
        }
        return selections;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    public void focusGained(FocusEvent event) {
    }

    public void focusLost(FocusEvent event) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public void rowDeselected(TableEvent e) {
    }

    public void rowDeselecting(TableEvent e) {
    }

    public void rowSelected(TableEvent e) {
        if (this.isVendorCluster) {
            int currentSelectedRow = e.getRow();
            String[] currentTableArray = this.getTable();
            boolean is9iRAC = false;
            if (currentTableArray != null) {
                boolean bl = is9iRAC = currentTableArray[currentSelectedRow].split(":")[3].equals("Y");
                if (is9iRAC) {
                    this.button3.setEnabled(false);
                } else {
                    this.button3.setEnabled(true);
                }
            }
        } else if (!this.button3.isEnabled()) {
            this.button3.setEnabled(true);
        }
    }

    public void rowSelecting(TableEvent e) {
    }

    public void cellSelected(GridEvent e) {
    }

    public void mouseClicked(MouseEvent e, Header header, int itemIndex) {
    }

    public void mousePressed(MouseEvent e, Header header, int itemIndex) {
    }

    public void mouseDragged(MouseEvent e, Header header, int itemIndex) {
    }

    public void mouseReleased(MouseEvent e, Header header, int itemIndex) {
    }

    public void mouseEntered(MouseEvent e, Header header, int itemIndex) {
    }

    public void mouseExited(MouseEvent e, Header header, int itemIndex) {
    }

    public void mouseMoved(MouseEvent e, Header header, int itemIndex) {
    }

    public void columnResizing(TableEvent e) {
    }

    public void columnResized(TableEvent e) {
    }

    public void rowResizing(TableEvent e) {
    }

    public void rowResized(TableEvent e) {
    }

    public void refreshRemovedArray() {
        boolean nodeFound = false;
        int removeNodeCounter = 0;
        if (this.spreadTableArray != null) {
            this.removedNodesPopulatedByAPI = new Vector();
            for (int i = 0; i < this.spreadTablePopulatedByAPI.length; ++i) {
                nodeFound = false;
                String a = this.spreadTablePopulatedByAPI[i].split(":")[0];
                for (int j = 0; j < this.spreadTableArray.length; ++j) {
                    String b = this.spreadTableArray[j].split(":")[0];
                    if (!a.equalsIgnoreCase(b)) continue;
                    nodeFound = true;
                    break;
                }
                if (nodeFound) continue;
                this.removedNodesPopulatedByAPI.add(removeNodeCounter++, a);
            }
        } else {
            this.removedNodesPopulatedByAPI = new Vector();
        }
    }

    public String[] combineArrays(String[] currentSpreadTableArray, String[] arrayFromFile) {
        Vector<String> finalVector = new Vector<String>();
        int vectorIndex = 0;
        for (int i = 0; i < arrayFromFile.length; ++i) {
            finalVector.add(vectorIndex++, arrayFromFile[i]);
        }
        int curIndex = arrayFromFile.length;
        for (int i = 0; i < currentSpreadTableArray.length; ++i) {
            String spreadTablePubNode = currentSpreadTableArray[i].split(":")[0];
            for (int j = 0; j < arrayFromFile.length; ++j) {
                String receivedArrayPubNode = arrayFromFile[j].split(":")[0];
                if (spreadTablePubNode.equalsIgnoreCase(receivedArrayPubNode)) continue;
                finalVector.add(vectorIndex++, currentSpreadTableArray[i]);
            }
        }
        String[] finalArray = new String[finalVector.size()];
        for (int i = 0; i < finalArray.length; ++i) {
            finalArray[i] = (String)finalVector.elementAt(i);
        }
        return finalArray;
    }

    private String[] modifyInputArray(String[] inputArray, String mode) {
        if (mode != null) {
            int[] selRows;
            String[] modifiedSpreadTable;
            String[] currentSpreadTable;
            if (mode.equals("A")) {
                currentSpreadTable = this.getTable();
                modifiedSpreadTable = null;
                if (currentSpreadTable == null) {
                    modifiedSpreadTable = new String[1];
                    modifiedSpreadTable = inputArray;
                } else {
                    modifiedSpreadTable = new String[currentSpreadTable.length + 1];
                    for (int i = 0; i < currentSpreadTable.length; ++i) {
                        modifiedSpreadTable[i] = currentSpreadTable[i];
                    }
                    modifiedSpreadTable[modifiedSpreadTable.length - 1] = inputArray[0];
                }
                this.spreadTableArray = modifiedSpreadTable;
            } else if (mode.equals("R")) {
                currentSpreadTable = this.getTable();
                modifiedSpreadTable = null;
                if (currentSpreadTable.length == 1) {
                    this.spreadTableArray = null;
                    return modifiedSpreadTable;
                }
                modifiedSpreadTable = new String[currentSpreadTable.length - 1];
                this.grid = this.myTable.getGrid();
                GridSelection gridSelObj = this.grid.getGridSelection();
                selRows = gridSelObj.getSelectedRows();
                if (selRows != null && modifiedSpreadTable != null) {
                    int index = 0;
                    for (int i = 0; i < currentSpreadTable.length; ++i) {
                        if (i == selRows[0]) continue;
                        modifiedSpreadTable[index++] = currentSpreadTable[i];
                    }
                    this.spreadTableArray = modifiedSpreadTable;
                    return this.spreadTableArray;
                }
            } else if (mode.equals("E")) {
                currentSpreadTable = this.getTable();
                modifiedSpreadTable = new String[currentSpreadTable.length];
                this.grid = this.myTable.getGrid();
                GridSelection gridSelObj = this.grid.getGridSelection();
                selRows = gridSelObj.getSelectedRows();
                if (selRows != null) {
                    for (int i = 0; i < currentSpreadTable.length; ++i) {
                        modifiedSpreadTable[i] = i == selRows[0] ? inputArray[0] : currentSpreadTable[i];
                    }
                    this.spreadTableArray = modifiedSpreadTable;
                    return this.spreadTableArray;
                }
            }
        }
        String[] modifiedArray = new String[5 * inputArray.length];
        String[] temp = new String[5];
        int idx = 0;
        for (int i = 0; i < inputArray.length; ++i) {
            temp = inputArray[i].split(":");
            modifiedArray[idx] = temp[0];
            modifiedArray[idx + 1] = temp[1];
            modifiedArray[idx + 2] = temp[2];
            modifiedArray[idx + 3] = temp[3];
            modifiedArray[idx + 4] = temp[4];
            idx += 5;
        }
        return modifiedArray;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        Point pt = this.mainPanel.getLocation();
        int top = (int)pt.getY();
        int left = (int)pt.getX();
        Object c = this;
        while (!(c instanceof Frame)) {
            c = ((Component)c).getParent();
        }
        if (source == this.button0) {
            OiClusterConfigFileInput fileInputDlg = null;
            if (this.isVendorCluster) {
                this.refreshRemovedArray();
            }
            fileInputDlg = new OiClusterConfigFileInput(left + 380, top + 270, this.isVendorCluster, this.spreadTableArray, this.spreadTablePopulatedByAPI, this.removedNodesPopulatedByAPI);
            fileInputDlg.showDialog((Frame)c);
            String exitMode = fileInputDlg.getExitMode();
            if (exitMode.equals("OK")) {
                String[] receivedArray = fileInputDlg.getSpreadTableValues();
                this.setTextField(fileInputDlg.getClusterName());
                this.rowHighlighted = 0;
                this.setTable(receivedArray, "F");
                this.passedClusterConfigFile = null;
            }
        } else if (source == this.button1) {
            OiClusterConfigAdd addDlg = new OiClusterConfigAdd(left + 380, top + 270);
            addDlg.showDialog((Frame)c);
            String exitMode = addDlg.getExitMode();
            if (exitMode.equals("OK")) {
                String newPubNodeName = addDlg.getText0();
                String newPrivateNodeName = addDlg.getText1();
                String newVirtualHostName = addDlg.getText2();
                String[] addRow = new String[]{newPubNodeName + ":" + newPrivateNodeName + ":" + newVirtualHostName + ":N:Y"};
                this.grid = this.myTable.getGrid();
                this.rowHighlighted = this.grid.getRowCount();
                this.setTable(addRow, "A");
                this.passedClusterConfigFile = null;
            }
        } else if (source == this.button2) {
            this.grid = this.myTable.getGrid();
            GridSelection gridSelObj = this.grid.getGridSelection();
            int[] selRows = gridSelObj.getSelectedRows();
            if (selRows != null) {
                this.rowHighlighted = selRows[0];
                OiClusterConfigEdit editDlg = new OiClusterConfigEdit(left + 380, top + 270, this.isVendorCluster, this.spreadTableArray[selRows[0]]);
                editDlg.showDialog((Frame)c);
                String exitMode = editDlg.getExitMode();
                if (exitMode.equals("OK")) {
                    String[] editedRow = new String[]{editDlg.getChangedValue()};
                    this.setTable(editedRow, "E");
                    this.passedClusterConfigFile = null;
                }
            }
        } else if (source == this.button3) {
            this.grid = this.myTable.getGrid();
            GridSelection gridSelObj = this.grid.getGridSelection();
            int[] selRows = gridSelObj.getSelectedRows();
            if (selRows != null) {
                this.rowHighlighted = selRows[0] - 1;
                String[] deleteRow = new String[]{this.spreadTableArray[selRows[0]]};
                this.setTable(deleteRow, "R");
                this.passedClusterConfigFile = null;
            }
        }
    }

    public static void main(String[] args) {
        BufferedFrame p = new BufferedFrame();
        OiClusterConfig tsttab = new OiClusterConfig();
        String[] str = new String[]{"123", "234", "1234", "4356", "34q543", "45324"};
        String[] DEF_LIST = new String[]{"host1:host1_priv1:host1-vip:N:Y", "host2:host2_priv2:host2-vip:Y:N", "host3:host3_priv3:host3-vip:N:Y"};
        tsttab.setVendorCluster(new Boolean(true));
        tsttab.setInitialTable(DEF_LIST);
        tsttab.setClusterConfigFile(null);
        tsttab.setTextField("mycluster");
        tsttab.setGridTable(null);
        p.add((Component)((Object)tsttab));
        p.setLocation(100, 200);
        p.setSize(630, 400);
        p.show();
    }

    static {
        totRows = 0;
    }

    public class MyKeyListener
    extends KeyAdapter {
        @Override
        public void keyPressed(KeyEvent evt) {
            if (evt.getKeyChar() == 'a') {
                // empty if block
            }
            if (evt.getKeyCode() == 36) {
                // empty if block
            }
        }
    }
}

